
!"Pocket Smalltalk fileout - 2003N68-15:26:47"!


!Object constantsFor: 'PalmOS: System Alert'!

categoryAllUsedAlert 10014! 
CategoryExistsAlert 10012! 
ClipboardLimitAlert 10007! 
DemoUnitAlert 10016! 
DeviceFullAlert 10013! 
LowBatteryAlert 10002! 
LowCradleChargedBatteryAlert 10018! 
MergeCategoryAlert 10005! 
MergeCategoryNo 1! 
MergeCategoryYes 0! 
NoDataToBeamAlert 10017! 
privateRecordInfoAlert 10006! 
RemoveCategoryAlert 10015! 
RemoveCategoryNo 1! 
RemoveCategoryYes 0! 
SelectACategoryAlert 10000! 
UndoAlert 10004! 
UndoCancelButton 1! 
VeryLowBatteryAlert 10003! 
VeryLowCradleChargedBatteryAlert 10019! !

ValueHolder subclass: #ModelHolder
	instanceVariableNames: 'subValueHoldersByAccessor settersByAccessor'
	classVariableNames: ''!

ReadStream subclass: #HandleReadStream
	instanceVariableNames: 'pointer'
	classVariableNames: ''!

WriteStream subclass: #HandleWriteStream
	instanceVariableNames: 'pointer'
	classVariableNames: ''!

!ModelHolder comment!
Use ValueHolder for a single instance variable, and use this class for a model having multiple instance variables.

It encapsulate update behavior within #updateIfNecessary ! !


!ModelHolder methodsFor: 'action'!

updateIfNecessary
	" ^ <Boolean>
	updates any attribute if it has changed. Returns true if at least one attribute 
	was updated."
	 
	| changed |
	changed := false.
	subValueHoldersByAccessor keysAndValuesDo: [:accessor :holder |
		(value perform: accessor) == holder value ifFalse: [
			value 
				perform: (settersByAccessor at: accessor) 
				with: holder value.
			changed := true]].
	^changed!

addValueHolderFor: anAccessor setter: aSetter
	" ^ <ValueHolder>
	anAccessor	<Symbol>
	aSetter		<Symbol>
	add a new valueHolder to my model holder"
	
	| holder | 
	holder := ValueHolder with: nil.
	subValueHoldersByAccessor at: anAccessor put: holder.
	settersByAccessor at: anAccessor put: aSetter.
	^holder
! !


!ModelHolder methodsFor: 'initialization'!

initialize
	"Use 2 identity dictionaries for performance"
	
	super initialize.
	subValueHoldersByAccessor := IdentityDictionary new.
	settersByAccessor := IdentityDictionary new
! !


!ModelHolder methodsFor: 'accessing'!

value: newValue
	" ^ self
	newValue	<Model>
	If a new model replaces the previous one then update the model holder
	which will trigger a model update event.
	Otherwise finds out which inst.var. was changed and then triggers only
	an inst.var update event"
	
	value == newValue ifFalse: [
		subValueHoldersByAccessor keysAndValuesDo: [:accessor :holder |
			holder perform: #value: with: (newValue perform: accessor)].
		^super value: newValue].
	subValueHoldersByAccessor keysAndValuesDo: [:accessor :holder |
		(value perform: accessor) == (newValue perform: accessor) ifFalse: [
			holder perform: #value: with: (newValue perform: accessor)]]
!

valueHolderAt: anAccessor
	" ^ <ValueHolder>
	anAccessor	<Symbol>
	retrieves the value holder for a specific inst.var."
	
	^subValueHoldersByAccessor at: anAccessor ifAbsent: [nil]! !


!HandleReadStream comment!
Use this class when you want to read data from handle comming directlty from a database record.
Use the right accessing method to read data
	next reads 1 byte
	nextWord reads 2 bytes
	nextDword reads 4 bytes
	nextString reads a string up to a null character! !


!HandleReadStream methodsFor: 'initialization'!

close
	"We are done with reading so free memory"
	
	collection unlock.
"	collection freeHandle. "
	pointer := nil!

on: streamedCollection
	"Given a handle to a record, creates a stream. Set the limit to be the size of
	the handle and lock it for use"
	
	super on: streamedCollection.
	limit := CPointer handleSize: collection.
	pointer := streamedCollection lock! !


!HandleReadStream methodsFor: 'accessing'!

nextDword
	" ^ <LongInteger> or <Double>
	Read 4 bytes"

	| offset  object |
	offset := 4.
	position odd ifTrue: [
		offset := 3. 
		position := position +1].
	(limit between: position and: position + offset - 1)
		ifTrue: [self error: #endOfStream].
	object := pointer dwordAt: position.
	position := position + offset.
	^object!

nextString
	" ^ <String>
	Read as many bytes as necessary up to a null character"

	| offset  object pointerString |
	pointerString := pointer offsetBy: position.
	offset := SYSTRAP StrLen: pointerString.
	(limit between: position and: position + offset - 2)
		ifTrue: [self error: #endOfStream].
	object := String new: offset.
	SYSTRAP MemMove: object from: pointerString size: offset.
	position := position + offset + 1.	"To skip C null char"
	^object!

nextWord
	" ^ <SmallInteger>
	Read 2 bytes"

	| offset  object |
	offset := 2.
	position odd ifTrue: [
		offset := 1. 
		position := position +1].
	(limit between: position and: position + offset - 1)
		ifTrue: [self error: #endOfStream].
	object := pointer wordAt: position.
	position := position + offset.
	^object!

next
	" ^ <Byte>
	Read one byte"
	
	| object |
	position >= limit ifTrue: [self error: #endOfStream].
	object := pointer byteAt: position.
	position := position + 1.
	^object! !


!HandleWriteStream comment!
Use this class when you want to save data into a handle, to be stored in a database
Use the right method to store data
	nextPut: stores 1 byte
	nextPutAll: stores everything bigger than 1 byte by using double dispatch! !


!HandleWriteStream methodsFor: 'stream operations'!

nextPut: anObject
	" ^ self
	anObject	<Boolean> or <Character>
	Store a byte into the stream"
	
	position >= limit ifTrue: [self expandCollection].
	pointer byteAt: position put: anObject.
	position := position + 1

!

nextPutAll: anObject
	" ^ self
	anObject	<Double> or <Integer> or <String>
	Store several bytes into the stream. Use double dispatch since behavior 
	for handles depends on memory anObject requires."
	
	anObject nextPutAllFor: self
! !


!HandleWriteStream methodsFor: 'initialization'!

close

	pointer := nil!

on: streamedCollection
	"Given a handle to a record, creates a stream. Set the limit to be the size of
	the handle and lock it for use"
	
	super on: streamedCollection.
	limit := CPointer handleSize: collection.
	pointer := streamedCollection lock! !


!HandleWriteStream methodsFor: 'accessing'!

contents
	" ^ <String>
	We are done with storing data so free memory"
	
	| string |
	string := String new: position.
	SYSTRAP MemMove: string from: pointer bytes: position.
	collection 
		unlock;
		freeHandle.
	^string! !


!HandleWriteStream methodsFor: 'private'!

wordNextPutAll: anObject
	" ^ self
	anObject	<SmallInteger>
	SmallIntegers are stored in 2 bytes"

	| offset |
	offset := 2.
	position odd ifTrue: [offset := 3].
	[position + offset >= limit] whileTrue: [self expandCollection].
	position odd ifTrue: [self nextPut: 0].
	pointer wordAt: position put: anObject.
	position := position + offset!

stringNextPutAll: anObject
	" ^ self
	anObject	<String>
	1 is added for the C null charater"

	[position + anObject size >= limit] whileTrue: [self expandCollection].
	SYSTRAP 
		MemMove: (pointer offsetBy: position) 
		from: anObject
		size: anObject size.
	position := position + anObject size.
	self nextPut: 0!

dwordNextPutAll: anObject
	" ^ self
	anObject	<LongInteger> or <Double>
	LongIntegers and Double are stored in 4 bytes"

	| offset |
	offset := 4.
	position odd ifTrue: [offset := 5].
	[position + offset >= limit] whileTrue: [self expandCollection].
	position odd ifTrue: [self nextPut: 0].
	pointer dwordAt: position put: anObject.
	position := position + offset
!

expandCollection
	"Need to expand so free the handle, grow as much as needed and lock the new handle"
	
	| error |
	collection unlock.
	error := SYSTRAP MemHandleResize: collection size: (limit + (limit // 2 max: 20)).
	(error bitShift: -8) isZero ifFalse: [
		self incomplete: 'Use exceptions'.
		^self error: 'Could not allocate more memory to handle'].
	limit := CPointer handleSize: collection.
	pointer := collection lock.
! !


!Object methodsFor: 'initialization'!

initialize

	^self! !


!SortedCollection methodsFor: 'private'!

reallyExpandAtEndBy: amount
	"TREG: bug, missing method"
	
	| sort |
	sort := sortBlock.
	super reallyExpandAtEndBy: amount.
	sortBlock := sort.
! !


!Model class methodsFor: 'instance creation'!

new

	^super new initialize! !


!Integer class methodsFor: 'parsing'!

readFrom: stream radix: radix
	"	^ nil or Integer
	TREG: if the stream has no digit return nil"
	
	| value char position |
	position := stream position.
	[(char := stream peek) notNil and: [char isDigit]] 
		whileTrue: [
			value := 0.
			stream next].
	value ifNil: [^nil].
	stream position: position.
	value := 0.
	[(char := stream peek) notNil and: [char isDigit]]
		whileTrue: [
			char digitValue >= radix
				ifTrue: [^value].
			value := value * radix + char digitValue.
			stream next].
	^value.! !


!Dictionary methodsFor: 'accessing'!

at: key ifAbsentPut: block
	"TREG: added for code simplicity"
	
	| value |
	(value := self at: key ifAbsent: block) ifNotNil: [self at: key put: value].
	^value! !


!Object methodsFor: 'utility'!

trace: aString
	"Convenience method to debug"
	
	Form notify: aString! !


!Object methodsFor: 'utility'!

incomplete: aString
	"Convenience method: to remind work to be done"
	
	^self! !


!String methodsFor: 'streaming'!

nextPutAllFor: aStream
	"Private: used for double dispatch for a handleWriteStream"
	
	aStream stringNextPutAll: self! !


!SmallInteger methodsFor: 'streaming'!

nextPutAllFor: aStream
	"Private: used for double dispatch for a handleWriteStream"

	aStream wordNextPutAll: self
! !


!Double methodsFor: 'streaming'!

nextPutAllFor: aStream
	"Private: used for double dispatch for a handleWriteStream"

	aStream dwordNextPutAll: self! !


!CPointer methodsFor: 'streaming'!

readStream
	" ^ <HandleReadStream>
	creates a stream around a handle to stored data into a database record"

	^HandleReadStream reallyOn: self! !


!CPointer methodsFor: 'streaming'!

writeStream
	" ^ <HandleWriteStream>
	creates a stream around a handle to stored data into a database record"

	^HandleWriteStream reallyOn: self! !


!LongInteger methodsFor: 'streaming'!

nextPutAllFor: aStream
	"Private: used for double dispatch for a handleWriteStream"

	aStream dwordNextPutAll: self
! !


